$Title: SplitVA, Split Value Added for GTAP water 2011

*      ----------------------------------------------------------------      *
*                                                                            *
*                  Global Trade Analysis Project                             *
*                      GTAP Water database                                   *
*         Estimate Land Value Added by River Basin for 2011                  *
*                                                                            *
*      ----------------------------------------------------------------      *

$ontext
Paper:
    Haqiqi I., F. Taheripour, J. Liu, and D. van der Mensbrugghe.
    "Introducing Irrigation Water into GTAP Database Version 9"
    Journal of Global Economic Analysis
    December, 2016.

Contact: ihaqiqi@purdue.edu
https://www.gtap.agecon.purdue.edu/resources/res_display.asp?RecordID=5168

--------------
Introduction
--------------
     This code assigns land value added to:
          - riverbasin
          - AEZ

     For making GTAP water database, we need to split land value added according to production.
     Then we calculate water value added to rain-fed and irrigated according to yield gap.
     So, we use PSD (2000) land use database by riverbasin AEZ and irrigated rain-fed information.

-------------
History
-------------
         Version 1 employs different order of variables for aggregation

-------------
Note
-------------
This program is used for construction of GTAP water Database 2011 for r140 and r19 regions.
The calculations are based on 126 global basins.
Note that River basin aggregation should not be done by simple summation.
Users should define their own mapping from 126 global riverbasins to a
consistent basin definition. River basins are not additive.

-------------
Contents
-------------
    (0) Define versions and methods
    (1) SPLIT CO2  AND ENERGY TO RAINFED AND IRRIGATED
    (2) Calculate AEZ share for ctl, oap, rmk, wol, frs
    (3) Calculate AEZ-RB shares for ctl, oap, rmk, wol, frs
    (4) Calculate AEZ-RB shares for crops
    (5) Remove value added of land in oap and adjust other agr
    (6) Remove value added of natlres in frs and adjust land
    (7) Split land value added (VFM, EVFA, EVOA) by rb-aez
    (8) Estimate Water Value Added by River Basin for 2011
    (9) Combined land use headers for better aggregation
    (10) Adjust for zero levels in h, q, w
    (11) Different aggregations
    (12) Aggregate to 20 river basins


Contact Iman Haqiqi, ihaqiqi@purdue.edu, for issues and concerns.

$offtext
*  ---------------------------------
*   (a) Define versions and methods
*  ---------------------------------

$setGlobal AggrName      R19_
$ontext
Decide the aggregation version:
   For 140 region use     R140_
   For 19 region use      R19_
Note: you can define your own simulation conditional to preparing data.
$offtext


$setGlobal Method        1
$ontext
Two methods for calculating value added
Method         0=Org, 1=Alt1, 2= Alt2
Look at section 8 for more details.
$offtext


$setGlobal oapv          oap_agr
$ontext
oapv can be:
   adjusted by pasture:             oap_pst
   adjusted by al ag secors:        oap_agr
   not adjusted:                    oap_NOT

The code is designed to adjusted the value added of OAP and FRS
Look at the follwoing for oap adjustemnt details:

Lee, H. L., Hertel, T. W., Rose, S., & Avetisyan, M. (2009).
An integrated global land use data base for CGE analysis of climate policy options.
Economic analysis of land use in global climate change policy, 42, 72-88.
$offtext


*    ----------------
*     (b) Read data
*    ----------------
sets
  GLOB Fictive global symbol table for prod_comm old and new
  REG, PROD_COMM(GLOB), ENDW_COMM, ENDW_COMM0
  AEZ, RB, CROP(GLOB)
  CROP_COMM(PROD_COMM), ic(CROP_COMM), rc(CROP_COMM)
  AEZ360, BAS360

* import 2011 GTAP land use data for land value added
parameters
*VFM header from basedata.har
  VFM      Endowments - Firms' Purchases at Market Prices

*EVOA header from basedata.har
  EVOA     Endowments - Output at Agents' Prices

*EVFA header from basedata.har
  EVFA     Endowments - Firms' Purchases at Agents' Prices
  ;

parameters
  HI, HR, QI, QR, HVST, PRDN, FRST, PSTR, CLND
  WTR01, WTR11
  ;

$Gdxin ../%AggrName%in/Mappings.gdx
$Load GLOB
$Gdxin

$Gdxin ../%AggrName%in/VA.gdx
$Load REG, PROD_COMM
$Gdxin

$Gdxin ../%AggrName%in/Mappings.gdx
$Load crop_comm, ic, rc, aez360, bas360, ENDW_COMM0
$Gdxin

$Gdxin ../%AggrName%in/VA.gdx
$Load VFM, EVFA, EVOA
$Gdxin

$Gdxin ../%AggrName%in/WaterLandUse.gdx
$Load HI, HR, QI, QR, HVST, PRDN, FRST, PSTR, CLND, AEZ, RB, CROP, WTR11, WTR01
$Gdxin

alias(crop,c) , (reg,r), (aez,a), (rb,b), (prod_comm,g), (crop_comm, cr);
set
  map_crop(*,crop)
  /
  pdri  .  pdr
  pdrn  .  pdr
  whti  .  wht
  whtn  .  wht
  groi  .  gro
  gron  .  gro
  v_fi  .  v_f
  v_fn  .  v_f
  osdi  .  osd
  osdn  .  osd
  c_bi  .  c_b
  c_bn  .  c_b
  pfbi  .  pfb
  pfbn  .  pfb
  ocri  .  ocr
  ocrn  .  ocr
  /
  NONCROP(prod_comm) /ctl, oap, rmk, wol, frs/
  AGR /pdr, wht, gro, v_f, osd, c_b, pfb, ocr, ctl, oap, rmk, wol, frs, crp/
  NCROP_COMM(GLOB)
  ;
NCROP_COMM(PROD_COMM) = yes;
NCROP_COMM(CROP_COMM) = NO;
alias(noncrop, nc) ;



*(1) split co2 and energy to rainfed and irrigated
$include Split_energy.gms

*(2) Calculate AEZ share for ctl, oap, rmk, wol, frs
$include Est_AEZshr.gms

*(3) Calculate AEZ-RB shares for ctl, oap, rmk, wol, frs
$include Est_RBshr.gms

*(4) Calculate AEZ-RB shares for crops
$include Est_RBAEZshr.gms

*(5)  Remove value added of land in oap and adjust other agr
$include Adj_oap.gms

*(6) Remove value added of NatlRes in frs and adjust land
$include Adj_frs.gms

*(7) Split land value added (VFM, EVFA, EVOA) by rb-aez
$include Split_RBAEZ.gms

*(8) Split Value added to Land and Water for GTAP water 2011
$include Est_wat.gms

*(9) Combined land use headers for better aggregation
$include Cmb_vol.gms

*(10) Adjust for zero levels in h, q, w
$include Adj_vol.gms

*(11) Value added by 126 RB and 18 AEZ
$include VA_RB126.gms

*(12) aggregate to 20 river basins
$include VA_RB20.gms


alias(endw_comm,ENDW_COM)
alias(prod_comm,PROD_COM)


parameter Ver "<<GTAP-Water Value Added for 2011, %AggrName%, Method: %Method% (Dec 2016)>>" /1/;

execute_unload '%AggrName%VA_%Method%_%oapv%.gdx'
  Ver
  adj_flag
  OAPver
  vfm, evfa, evoa
  endw_com, prod_com, bas360, reg, AEZ360
  water, production, area, landcover, CROP_COMM, COVR, WATER_INDS
  AGR_COMM, AEZ18, BAS20, LW, ltype, crop, rb
 VFMC, VFMZ, VFMA, VFMB, VFMW,
 VFAC, VFAZ, VFAA, VFAB, VFAW,
 VOAC, VOAZ, VOAA, VOAB, VOAW, VOAO
 WATC, WATZ, WATA, WATB, WATW, WATO
 PRDC, PRDZ, PRDA, PRDB, PRDW, PRDO
 HVSC, HVSZ, HVSA, HVSB, HVSW, HVSO
 COVC, COVZ, COVA, COVB, COVW, COVO
*  shr_water, shr_wat2, shr_wat, check
*  shr_frst, shr_pstr, bas_shr_frst, bas_shr_pstr, aez_shr
*  shr_irr, shr_rfd
execute "gdx2har %AggrName%VA_%Method%_%oapv%.gdx ../%AggrName%va_ir_rbaez_%oapv%/gtapw_va_%Method%.har";


execute_unload '%AggrName%CO2.gdx'
 MDF, MDG, MDP, MIF, MIG, MIP
 FUEL_COMM, REG, PROD_COMM
execute "gdx2har %AggrName%CO2.gdx ../%AggrName%va_ir_rbaez_%oapv%/CO2.har";


execute_unload '%AggrName%GSDVOLE.gdx'
 EDF, EDG, EDP, EIF, EIG, EIP, sNATd, EXI,GWH
 ERG_COMM, REG, PROD_COMM, NEWCOM, NEWERG
execute "gdx2har %AggrName%GSDVOLE.gdx ../%AggrName%va_ir_rbaez_%oapv%/GSDVOLE.har";





